require 'cgikit/key_value_coding'
require 'cgikit/utilities'
require 'cgikit/directaction'

module CGIKit::Project

  class ConfigurationTemplate < Template

    def template_en
      <<EOF
module #{@project.name}

  class Application < CGIKit::Application

    def configure
      configure_package
      configure_component
      configure_session
      configure_paths
      configure_localization
      configure_request_handlers
      configure_classes
    end


    def configure_package

      # Required packages:
      # Specify package names to load.
      # ( packages in "packages" directory are loaded automatically)
      # @required_packages = []

      # Main package options:
      # Configuration for loading main package (this application).
      # If you create the application with ckproject,
      # you don't need configure this.
      #
      # :component_load_type
      #   Component load type. Specify 'autoload' or 'require'.
      #   Default value is 'require'.
      # :package_class_name
      #   Module name to be used with autoloading component classes.
      #
      # @main_package_options = {}

    end


    def configure_component

      # Main page:
      # If session ID or context ID aren't specified, this component is shown. 
      @main = #{@project.name}::MainPage

      # Error page:
      # Name or class of an error page component to show caught errors.
      @error_page = CGIKit::ErrorPage

      # Cache template:
      # Whether or not caches templates to reduce parsing load.
      @cache_template = true

      # Validating API of elements:
      # Whether or not validates setting of attributes for each elements.
      # If wrong attribute name or combination are found, raises error.
      @validate_api = true

    end


    def configure_session

      # Page cache size:
      # Size to cache components permanently in session.
      # Newly generated page is cached automatically.
      # If holded page size is over the value, oldest pages are deleted.
      @page_cache_size = 30

      # Permanent page cache size:
      # Size to cache components permanently in session.
      # Permanent page cache is cached optionally, not automatically caching.
      # If holded page size is over the value, oldest pages are deleted.
      @permanent_page_cache_size = 30

      # Session timeout:
      # Seconds until the session has timed out.
      @timeout = 60 * 60 * 24 * 7

      # Session cookie expires:
      # Expiry date of cookie for session. If you set the value to nil,
      # session cookies will be invalid when closing browser.
      @session_cookie_expires = 60 * 60 * 24 * 7

      # Storing session IDs in URLs:
      # Enables or disables the use of URLs for storing session IDs.
      @store_in_url = true

      # Storing session IDs in cookies:
      # Enables or disables the use of cookies for storing session IDs.
      @store_in_cookie = false

      # Authorizing session by user agent:
      # Enables or disables session authorization by browsers.
      # If you set the value to true, the application raises error
      # when an user accesses it with browser that is different from
      # one registered session.
      @auth_by_user_agent = false

      # Authorizing session by IP addresses:
      # Enables or disables session authorization by IP addresses.
      # If you set the value to true, the application raises error
      # when an user accesses it with IP address that is different from
      # one registered session.
      @auth_by_remote_addr = false

      # Session key:
      # This key is used in cookie.
      @session_key = '_session_id'

      # Session key in direct action:
      # This key is used in hidden fields of form and URL when using direct action.
      @direct_action_session_key = '_sid'

      # Session sweeping password:
      # Password for session sweeping page.
      # To disable the page, set this value to nil.
      # The page is a direct action "#{CGIKit::DirectAction::SWEEP_ACTION_NAME}".
      @sweep_password = nil

    end


    def configure_paths

      # Component paths:
      # The file system paths for components. Components are searched under it.
      @component_path = 'components'

      # Document root directory:
      # @document_root = '/var/www/htdocs'

      # Resources directory:
      # This directory includes files to be used by the application,
      @resource_path = 'resources'

      # Web server resources directory:
      # This directory includes files to be displayed to browser.
      # The files are used by Image element, etc.
      @web_server_resource_path = 'www'

      # Temporary directory:
      # Temporary directory to be used by the framework.
      # The framework uses this to store sessions and template caches.
      @tmpdir = './tmp' || ENV['TMP'] || ENV['TEMP']

    end


    def configure_localization

      # Encoding for form data:
      # Encoding to encode character code of form data.
      # The default implementation does nothing.
      # If you use Japanese encoding, require 'cgikit/lang/ja'.
      # Or if you want to use other encoding, implement custom encoding
      # by overwriting DynamicElement#encode_string and failed_encode_string.
      # @encoding = nil

    end


    def configure_classes

      # Direct action class:
      @direct_action_class = #{@project.direct_action.class_name}

      # Session class:
      @session_class = #{@project.session.class_name}

      # Context class:
      # @context_class = CGIKit::Context

      # HTML parser class:
      # @htmlparser_class = CGIKit::HTMLParser::HTMLParser

    end


    def configure_request_handlers

      # Component request handler key:
      # @component_request_handler_key = 'c'

      # Direct action request handler key:
      # @direct_action_request_handler_key = 'd'

      # Resource request handler key:
      # @resource_request_handler_key = 'r'

      # Component request handler:
      # @component_request_handler = CGIKit::ComponentRequestHandler.new(self)

      # Direct action request handler:
      # @direct_action_request_handler = CGIKit::DirectActionRequestHandler.new(self)

      # Resource request handler:
      # @resource_request_handler = ResourceRequestHandler.new(self)

      # Default request handler:
      # This handler is used when the application receives a request
      # without request handler key.
      # If you set the value to direct action request handler,
      # the application invoke default direct action when first accessing it.
      # The default value is component request handler.
      # @default_request_handler = @component_request_handler

    end

  end

end
EOF
    end

  end

end

