require 'aop/aop'
require 'logger'

module CGIKit
  
  class LoggerAspect < Aspect
    
    def self.init_logger(out = $stderr)
      @logger = ::Logger.new(out)
    end
    
    def self.logger
      @logger
    end
    
    include Aspect::Context
    
    advice :log, :debug_context
    
    def debug_context(*args)
      ck_context = args.find{|i| CGIKit::Context === i }
      
      msg = current_context(args[0]) + ' CGIKIt::Context: ' + ck_context.context_id.to_s
      logger.debug(msg)
      a = yield
      a
    end
    
    def log(*args)
      logger.debug(current_context(args[0]) + ' arguments: ' + args[0..-2].collect{|i| i.inspect}.join(', ') )
      a = yield
      a
    end
    
    def logger
      if target.respond_to?(:application)
        target.application.logger 
      else
        LoggerAspect.logger
      end
    end
    
    LoggerAspect.init_logger
    
  end

end
