module CGIKit

  class Delegate

    module TextFieldDelegate

      def textfield_set_value( value ); end
      def textfield_validate_value( value ); end
      def textfield_will_generate_tag( tag ); end

    end

  end


  class TextField < DynamicElement
    class << self
      def create_api
        api = API.new(:TextField)
        type = Binding.new(:type)
        type.default = 'text'
        size = Binding.new(:size)
        maxlength = Binding.new(:maxlength)
        api << type
        api << size
        api << maxlength
        api << name_binding()
        api << value_binding(true, true)
        api << enabled_binding()
        set_validation(api)
        api
      end
    end

    def begin_context( context )
      take_value(:name)
      context.increment(@values[:name])
    end

    def take_values_from_request( request, context )
      if value = value_from_request(request, context) then
        ask(:textfield_validate_value) do |d|
          unless d.textfield_validate_value(value) then
            value = nil
          end
        end
        ask(:textfield_set_value) do |d|
          value = d.textfield_set_value(value)
        end
        set_value(:value, value)
        validate(:value)
      end
    end

    def append_to_response( response, context )
      take_bool(:enabled)
      take_value(:value)
      take_value(:type)
      take_value(:size)
      take_value(:maxlength)
      attrs = { :type => @values[:type], :value => @values[:value],
        :size => @values[:size], :maxlength => @values[:maxlength],
        :name => name_value(context), :disabled => !@values[:enabled] }
      attrs.update(optional_attributes())

      tag = HTMLTag.textfield(attrs, other_attribute())
      ask(:textfield_will_generate_tag) do |d|
        tag = d.textfield_will_generate_tag(tag) || tag
      end
      if tag[:value] and (tag[:type] != 'password') then
        tag[:value] = escaped_string(tag[:value])
      end
      response.content << tag.empty_tag
    end
  end

end
