#!/usr/bin/ruby

$LOAD_PATH.unshift('../../')

require 'cgikit'
require 'components/MainPage'
require 'components/SessionErrorPage'

# handles session errors
class CGIKit::Application

  def handle_session_error( error )
    error_page       = page('SessionErrorPage')
    error_page.error = error
    error_page.debug = @debug
    error_page
  end
  
end


app = CGIKit::Application.new
app.component_path = 'components'

# app.timeout             = 1
app.store_in_url        = true
app.store_in_cookie     = true
app.auth_by_user_agent  = true
app.auth_by_remote_addr = true
#app.manage_session      = false
app.session_key         = 'cgikit_session_test'

app.run
