module Examples

  class SourcePage < CGIKit::Component

    attr_accessor :source

    def init( *args )
      @source = args[0]
    end

    def body( suffix )
      file = @source.package.
        path_for_component("#{@source.base_name}.#{suffix}", request.languages)
      File.new(file).readlines.join
    end

    def basename( klass )
      klass.to_s.split('::').last
    end
      
    def html_source
      body("html")
    end

    def declaration_source
      body("ckd")
    end

    def ruby_source
      body("rb")
    end

  end

end
