if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'test_common'
end


# request_handler_key, application_path, query_string
class TestRequestHandler < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@handler = RequestHandler.new(@app)
		@request = Request.new
		@sid = 'sessionid'
		@cid = '0.1.2.3.4.5'
		@request.request_handler_path = "/c/#@sid/#@cid"
	end

	def test_request_handler_key
		@request.request_handler_path = '/c/session_id/context_id'
		assert_equal('c', @handler.request_handler_key(@request))
	end

	def test_application_path
		server = 'localhost'
		port = 80
		script = '/cgi-bin/test.cgi'
		@request.server_name = server
		@request.server_port = port
		@request.script_name = script
		assert_equal("http://#{server}/cgi-bin/test.cgi", @handler.application_path(@request))
		assert_equal("https://#{server}/cgi-bin/test.cgi", @handler.application_path(@request, true))
		assert_equal("http://#{server}:8080/cgi-bin/test.cgi", @handler.application_path(@request, false, 8080))
	end

	def test_query_string
		query = {:key=>'value', :array=>[true, false], :nil=>nil}
		str = "array=true;array=false;key=value;nil"
		assert_equal(str, @handler.query_string(query))

		query = {:FrontPage=>nil}
		assert_equal('FrontPage', @handler.query_string(query))
	end

	def test_session_id_from_url_without_request_handler_path
		@request.request_handler_path = nil
		assert_nil(@handler.session_id_from_url(@request))
	end

	def test_session_id_from_url_with_session_id_and_context_id
		@request.request_handler_path = "/c/#@sid/#@cid"
		assert_equal(@sid, @handler.session_id_from_url(@request))
	end

	def test_session_id_from_url_with_session_id
		@request.request_handler_path = "/c/#@sid"
		assert_equal(@sid, @handler.session_id_from_url(@request))
	end

	def test_session_id_from_url_with_invalid_session_id
		@request.request_handler_path = '/c/$#*&(*&@@#$!'
		assert_nil(@handler.session_id_from_url(@request))
	end

	def test_session_id_from_cookie
		cookie = Cookie.new(@app.session_key, @sid)
		@request.cookies << cookie
		assert_equal(@sid, @handler.session_id_from_cookie(@request))
	end

	def test_session_id_from_cookie_without_cookie
		assert_nil(@handler.session_id_from_cookie(@request))
	end

	def test_session_id_from_cookie_with_invalid_cookie
		cookie = Cookie.new(@app.session_key, '!)(*&@*&^#$)(*&@#$')
		@request.cookies << cookie
		assert_nil(@handler.session_id_from_cookie(@request))
	end
end


if __FILE__ == $0 then
	suite = TestRequestHandler.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
