if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'TestApp/app'
end


class TestObject
	include CGIKit::KeyValueCoding

	attr_accessor :str, :hash, :array, :myself

	def initialize
		@access_attributes = true
		@str = 'value'
		@hash = {'key'=>str, 'value'=>true}
		@hash['self'] = @hash
		@hash2 = @hash
		@array = [true, false, nil]
		@myself = self
		@yourself = {}
	end
end


# method, stored, variable, handle, error
# keypath
# Object, Array, Hash
class TestKeyValueCoding < Test::Unit::TestCase
	def setup
		@obj = TestObject.new
	end

	def test_value_for_key
		assert_equal('value', @obj.value_for_key("str"))
		assert_equal({}, @obj.value_for_key("yourself"))
	end

	def test_value_for_keypath
		assert_equal('value', @obj.value_for_keypath("myself.str"))
	end

	def test_take_value_for_key
		@obj.take_value_for_key('str', 'string')
		assert_equal('string', @obj.value_for_key("str"))
	end

	def test_take_value_for_keypath
		@obj.take_value_for_keypath('myself.str', false)
		assert_equal(false, @obj.value_for_keypath("myself.str"))
	end

	def test_access_attributes_directly
		value = 'test'
		@obj.take_value_for_key('message', value)
		assert_equal(value, @obj.value_for_key('message'))
		assert_equal(@obj.value_for_key('message').object_id,
			@obj.value_for_key('message').object_id)

		@obj.access_attributes = false
		assert_raises(NoMethodError) do 
			@obj.take_value_for_key('message', value)
		end
	end

	def test_method_missing
		@obj.test_missing = 'value'
		assert_equal('value', @obj.test_missing)

		@obj.access_attributes = false
		assert_raises(NoMethodError) do 
			assert_equal('value', @obj.test_missing)
		end
	end
end

if __FILE__ == $0 then
	suite = TestKeyValueCoding.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
