if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/TextFieldPage/TextFieldPage'
	require 'test_common'
end


class TestElementTextField < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = TextFieldPage
		@does_test_other = true
	end

	def test_api_correct
		dec = {:TestAPI => {:element => TextField, :value => :test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element => TextField}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_value
		expected = 'test_value'
		response = @app.run
		command = Command.new(response)
		command.control(TextFieldPage::TEST_VALUE_NAME)[:value] = expected
		command.submit_at(0).submit
		response = @app.run(command)
		assert_equal(expected, response.component.value_string)
	end

	def test_password
		response = @app.run()
		command = Command.new(response)
		type = command.control(TextFieldPage::TEST_PASSWORD_NAME)[:type]
		assert_equal('password', type)
	end

	def test_hidden
		response = @app.run()
		command = Command.new(response)
		type = command.control(TextFieldPage::TEST_HIDDEN_NAME)[:type]
		assert_equal('hidden', type)
	end

	def test_validate
		response = @app.run()
		command = Command.new(response)
		expected = 'test'
		command.control(TextFieldPage::TEST_VALIDATE_NAME)[:value] = expected
		command.submit_at(0).submit
		response = @app.run(command)
		assert(response.component.pass)

		command = Command.new(response)
		expected = 'not test'
		command.control(TextFieldPage::TEST_VALIDATE_NAME)[:value] = expected
		command.submit_at(0).submit
		response = @app.run(command)
		assert_equal(false, response.component.pass)
	end

	def test_enabled
		response = @app.run()
		command = Command.new(response)
		assert_equal(false, command.control(TextFieldPage::TEST_ENABLED_NAME).enabled?)
	end

end


if __FILE__ == $0 then
	suite = TestElementTextField.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
