if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/ContentPage/ContentPage'
	require 'TestApp/TextFieldPage/TextFieldPage'
	require 'TestApp/SwitcherPage/SwitcherPage'
	require 'test_common'
end


class TestElementSwitcher < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = SwitcherPage
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Switcher}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_current
		dec = {:TestAPI => {:element=>Switcher, :component=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_component_display
		response = @app.run
		pattern = /#{SwitcherPage::TEST_COMPONENT_DISPLAY_OK}/
		assert_match(pattern, response.content)
	end

	def test_component_set_values
		expected = 'test_value'
		response = @app.run
		command = Command.new(response)
		command.control(TextFieldPage::TEST_VALUE_NAME)[:value] = expected
		command.submit_at(0).submit
		response = @app.run(command)
		pattern = /#{expected}/
		assert_match(pattern, response.content)
	end
end


if __FILE__ == $0 then
	suite = TestElementSwitcher.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
