if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/SubmitPage/SubmitPage'
	require 'test_common'
end


class TestElementSubmit < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = SubmitPage
		@does_test_other = true
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Submit}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_either_bound
		dec = {:TestAPI => {:element=>Submit, :action=>:action, :direct_action=>:direct}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_action_bound
		dec = {:TestAPI => {:element=>Submit, :action=>:action}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_direct_action_with_action_class
		dec = {:TestAPI => {:element=>Submit, :direct_action=>'default',
			 :action_class=>DirectAction}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_direct_action_without_action_class
		dec = {:TestAPI => {:element=>Submit, :direct_action=>'default'}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	# action, enabled, direct_action, value, multiple submit

	def test_value
		response = @app.run
		command = Command.new(response)
		submit = command.element(SubmitPage::TEST_VALUE_NAME)
		assert_equal(SubmitPage::TEST_VALUE, submit[:value])
	end

	def test_enabled
		response = @app.run()
		command = Command.new(response)
		assert_equal(false, command.control(SubmitPage::TEST_ENABLED_NAME).enabled?)
	end

	def test_action
		response = @app.run
		command = Command.new(response)
		command.submit(SubmitPage::TEST_ACTION_NAME).submit
		response = @app.run(command)
		assert_match(/#{SubmitPage::TEST_ACTION_OK}/, response.content)
	end

	def test_direct_action
		response = @app.run
		command = Command.new(response)
		command.submit(SubmitPage::TEST_DIRECT_ACTION_NAME).submit
		response = @app.run(command)
		assert_match(/#{SubmitPageDirectAction::TEST_DIRECT_ACTION_OK}/, response.content)
	end

end


if __FILE__ == $0 then
	suite = TestElementSubmit.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
