if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/NestingComponentPage/NestingComponentPage'
	require 'TestApp/ContentPage/ContentPage'
	require 'test_common'
end


class TestElementContent < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = NestingComponentPage
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Content}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_content
		response = @app.run
		content_start = ContentPage::CONTENT_START
		content_end = ContentPage::CONTENT_END
		content = NestingComponentPage::TEST_CONTENT_STRING
		pattern = /#{content_start}\s*#{content}\s*#{content_end}/m
		assert_match(pattern, response.content)
	end

end


if __FILE__ == $0 then
	suite = TestElementContent.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
