if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/BrowserPage/BrowserPage'
	require 'test_common'
end


class TestElementBrowser < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = BrowserPage
		@does_test_other = true
	end

	def test_api_correct
		dec = {:TestAPI => {:element=>Browser, :list=>:test, :item=>:test,
			:display=>:test, :selection=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_selections_and_selected_values
		dec = {:TestAPI => {:element=>Browser, :selections=>:test, :selected_values=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_item_and_value
		dec = {:TestAPI => {:element=>Browser, :list=>:test, :value=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_item_and_display
		dec = {:TestAPI => {:element=>Browser, :list=>:test, :display=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element => Browser}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_list_and_item
		response = @app.run()
		command = Command.new(response)
		assert(BrowserPage.test_list_and_item(command))
	end

	def test_selections_with_index
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(BrowserPage::TEST_SELECTIONS_WITH_INDEX_NAME)
		select.options[index].selected = true
		select.options[index+1].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		selections = component.value_for_key(BrowserPage::TEST_SELECTIONS)
		assert(selections.include?(BrowserPage::TEST_LIST[index]))
		assert(selections.include?(BrowserPage::TEST_LIST[index+1]))

		command = Command.new(response)
		select = command.control(BrowserPage::TEST_SELECTIONS_WITH_INDEX_NAME)
		assert(select.options[index].selected?)
		assert(select.options[index+1].selected?)
	end

	def test_selections_with_value
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(BrowserPage::TEST_SELECTIONS_WITH_VALUE_NAME)
		select.options[index].selected = true
		select.options[index+1].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		selections = component.value_for_key(BrowserPage::TEST_SELECTIONS)
		assert(selections.include?(BrowserPage::TEST_LIST[index]))
		assert(selections.include?(BrowserPage::TEST_LIST[index+1]))

		command = Command.new(response)
		select = command.control(BrowserPage::TEST_SELECTIONS_WITH_VALUE_NAME)
		assert(select.options[index].selected?)
		assert(select.options[index+1].selected?)
	end

	def test_selected_values_with_index
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(BrowserPage::TEST_SELECTED_VALUES_WITH_INDEX_NAME)
		select.options[index].selected = true
		select.options[index+1].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		selected_values = component.value_for_key(BrowserPage::TEST_SELECTED_VALUES)
		assert(selected_values.include?(index.to_s))
		assert(selected_values.include?((index+1).to_s))

		command = Command.new(response)
		select = command.control(BrowserPage::TEST_SELECTED_VALUES_WITH_INDEX_NAME)
		assert(select.options[index].selected?)
		assert(select.options[index+1].selected?)
	end

	def test_selected_values_with_value
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(BrowserPage::TEST_SELECTED_VALUES_WITH_VALUE_NAME)
		select.options[index].selected = true
		select.options[index+1].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		selected_values = component.value_for_key(BrowserPage::TEST_SELECTED_VALUES)
		assert(selected_values.include?(BrowserPage::TEST_LIST[index].object_id.to_s))
		assert(selected_values.include?(BrowserPage::TEST_LIST[index+1].object_id.to_s))

		command = Command.new(response)
		select = command.control(BrowserPage::TEST_SELECTED_VALUES_WITH_VALUE_NAME)
		assert(select.options[index].selected?)
		assert(select.options[index+1].selected?)
	end

	def test_enabled
		response = @app.run()
		command = Command.new(response)
		assert_equal(false, command.control(BrowserPage::TEST_ENABLED_NAME).enabled?)
	end

	def test_display
		response = @app.run()
		command = Command.new(response)
		assert(BrowserPage.test_display(command))
	end

	def test_escape
		response = @app.run
		command = Command.new(response)
		assert(BrowserPage.test_escape(command))
	end

	def test_value
		response = @app.run
		command = Command.new(response)
		assert(BrowserPage.test_value(command))
	end

	def test_multiple_true
		response = @app.run()
		command = Command.new(response)
		assert(command.control(BrowserPage::TEST_MULTIPLE_TRUE_NAME).multiple?)
	end

	def test_multiple_false
		response = @app.run()
		command = Command.new(response)
		assert_equal(false, \
			command.control(BrowserPage::TEST_MULTIPLE_FALSE_NAME).multiple?)
	end
end


if __FILE__ == $0 then
	suite = TestElementBrowser.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
