if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/TextFieldPage/TextFieldPage'
	require 'test_common'
end


class CGIKit::DirectAction
	def test_action; end
end

class ToplevelDirectAction < CGIKit::DirectAction
	include CGIKit

	def test_action
		response = Response.new
		response.content << "#{self.class}.test"
		@context.request.form_values.each do |key, value|
			response.content << "#{key}=#{value}"
		end
		response
	end

	def not_response_action
		nil
	end
end



# session_id, direct_action_and_action_name, url, direct_action_url, handle_request
class TestDirectActionRequestHandler < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@handler = DirectActionRequestHandler.new(@app)
		@request = Request.new
		@request.request_handler_key = 'd'
		@sid = 'sessionid'
		@cid = '0.1.2.3.4.5'
		@context = Context.new(@request, @app)
		@context.context_id = @cid
		@session = Session.new(@sid)
		@context.session = @session
		script = '/cgi-bin/test.cgi'
		@request.script_name = script
	end

	def test_session_id_from_query
		@request.form_values[@app.direct_action_session_key] = [@sid]
		assert_equal(@sid, @handler.session_id_from_query(@request))
	end

	def test_session_id_from_query_with_invalid_session_id
		@sid = "&%&&$&!&@"
		@request.form_values[@app.direct_action_session_key] = [@sid]
		assert_nil(@handler.session_id_from_query(@request))
	end

	def test_session_id_with_cookie
		@app.store_in_cookie = true
		cookie = Cookie.new(@app.session_key, @sid)
		@request.cookies << cookie
		assert_equal(@sid, @handler.session_id(@request))
	end

	def test_session_id_with_nothing
		assert_nil(@handler.session_id(@request))
	end

	def test_session_id_from_cookie_with_invalid_cookie
		cookie = Cookie.new(@app.session_key, '!)(*&@*&^#$)(*&@#$')
		@request.cookies << cookie
		assert_nil(@handler.session_id_from_cookie(@request))
	end

	def test_direct_action_and_action_name_from_nothing
		@request.request_handler_path = ""
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_action_name
		@request.request_handler_path = "/d/test"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('test', action_name)
	end

	def test_direct_action_and_action_name_from_invalid_action_name
		@request.request_handler_path = "/d/invalid"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_class
		@app.direct_action_class = ToplevelDirectAction
		@request.request_handler_path = "/d/ToplevelDirectAction"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(ToplevelDirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_class_and_invalid_action_name
		@request.request_handler_path = "/d/ToplevelDirectAction/abcde"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_moduled_class
		@request.request_handler_path = "/d/CGIKit::DirectAction"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_not_direct_action_subclass
		@request.request_handler_path = "/d/String"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_invalid_class
		@request.request_handler_path = "/d/InvalidDirectAction"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(DirectAction, direct_action.class)
		assert_equal('default', action_name)
	end

	def test_direct_action_and_action_name_from_both
		@app.direct_action_class = ToplevelDirectAction
		@request.request_handler_path = "/d/ToplevelDirectAction/test"
		direct_action, action_name = @handler.direct_action_and_action_name(@request)
		assert_equal(ToplevelDirectAction, direct_action.class)
		assert_equal('test', action_name)
	end

	def test_url
		@session.store_in_url = false
		url = "http://localhost/cgi-bin/test.cgi/d"
		assert_equal(url, @handler.url(@context))

		@session.store_in_url = true
		url = "http://localhost/cgi-bin/test.cgi/d?#{@app.direct_action_session_key}=#@sid"
		assert_equal(url, @handler.url(@context))
	end

	def test_direct_action_path
		assert_equal('', @handler.direct_action_path(DirectAction, DirectAction::DEFAULT_ACTION_NAME))
		assert_equal('test', @handler.direct_action_path(DirectAction, 'test'))
		assert_equal('ToplevelDirectAction', @handler.direct_action_path(ToplevelDirectAction, DirectAction::DEFAULT_ACTION_NAME))
		assert_equal('ToplevelDirectAction/test', @handler.direct_action_path(ToplevelDirectAction, 'test'))
	end

	def test_direct_action_url
		url = @handler.direct_action_url(@context, ToplevelDirectAction, 'test', {:key=>:value})
		assert_equal('http://localhost/cgi-bin/test.cgi/d/ToplevelDirectAction/test?key=value', url)
	end

	def test_handle_request
		request = Request.new
		request.request_handler_path = '/d/ToplevelDirectAction/test'
		@app.direct_action_class = ToplevelDirectAction
		response = @handler.handle_request(request)
		assert_match(/ToplevelDirectAction.test/, response.content)
		assert_kind_of(Response, response)
	end

	def test_handle_request_return_not_response_from_action
		request = Request.new
		request.request_handler_path = '/d/ToplevelDirectAction/not_response'
		@app.direct_action_class = ToplevelDirectAction
		assert_raises(DirectActionRequestHandler::ActionResultError) do
			@handler.handle_request(request)
		end
	end

	def test_handle_request_save_session
		@app.main = TextFieldPage
		@session.store_in_url = true
		@request.request_handler_path = '/d'
		@app.set_adapter_and_handler
		response = @handler.handle_request(@request)
		assert(@app.session_store.exist?(response.component.session.session_id))
	end
end


if __FILE__ == $0 then
	suite = TestDirectActionRequestHandler.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
