if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'TestApp/app'
end


class TestDeclaration < Test::Unit::TestCase
	include CGIKit

	def test_store_from_hash
		hash = {:String=>{:element=>String, :value=>:method, :escape=>false, :empty=>'no string'},
			:Repetition=>{:element=>:CKRepetition, :list=>:list, :item=>:item}}
		decs = DeclarationStore.new_from_hash hash
		assert_equal(:String, decs[:String].element_name)
		assert_equal(String, decs[:String].element_type)
		assert_equal(:method, decs[:String][:value].keypath)
		assert_equal("no string", decs[:String][:empty].value)
		assert_equal(false, decs[:String][:escape].value)
	end

	def test_store_with_file
		export = "{:String=>{:element=>String, :value=>:method, :escape=>false, :empty=>'no string'}, :Repetition=>{:element=>:CKRepetition, :list=>:list, :item=>:item}}"
		file = 'test_store_with_file'
		open(file, 'w') {|f| f.write(export)}

		decs = DeclarationStore.new_with_file(file)
		assert_equal(:String, decs[:String].element_name)
		assert_equal(String, decs[:String].element_type)
		assert_equal(:method, decs[:String][:value].keypath)
		assert_equal("no string", decs[:String][:empty].value)
		assert_equal(false, decs[:String][:escape].value)

		File.delete(file)
	end

end


if __FILE__ == $0 then
	suite = TestDeclaration.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
