if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
end

class TestContext < Test::Unit::TestCase

	include CGIKit

	def setup
		@context = Context.new
	end

	def test_accessors
		assert_equal('', @context.context_id)
	end

	def test_append
		@context.append 'Element'
		@context.append 'Name'
		assert_equal('Element.Name', @context.context_id)
	end

	def test_append_zero
		@context.append_zero
		@context.append_zero
		assert_equal('0.0', @context.context_id)
	end

	def test_delete_all
		@context.delete_all
		assert @context.context_id.empty?
	end

	def test_delete
		str = 'Name'
		@context.append(str)
		@context.delete
		assert_equal('', @context.context_id)
	end

	def test_increment
		@context.append_zero
		@context.increment
		assert_equal('1', @context.context_id)
	end

	def test_increment_after_append_string
		str = 'test'
		@context.append_zero
		@context.increment
		@context.append(str)
		@context.increment
		assert_equal('1.1', @context.context_id)
	end

	def test_increment_after_append_string
		str = 'test'
		@context.append_zero
		@context.append(str)
		@context.append(str)
		@context.delete
		@context.increment
		assert_equal('0.1', @context.context_id)
	end

	def test_direct_action_url
	end

	def test_complete_url
	end

	def test_component_action_url
	end

	def test_url
	end

end

if __FILE__ == $0 then
	suite = TestContext.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
