if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/ApplicationPage/ApplicationPage'
	require 'test_common'
end


class TestApplication < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = ApplicationPage
	end

	def test_session_creation_error
		response = @app.run
		command = Command.new(response)
		command[ApplicationPage::TEST_SESSION_CREATION_ERROR_KEY].submit
		@app.run(command)
		assert(@app.did_session_creation_error)
	end

	def test_session_restoration_error
		response = @app.run
		command = Command.new(response)
		command[ApplicationPage::TEST_SESSION_RESTORATION_ERROR_KEY].submit
		@app.run(command)
		assert(@app.did_session_restoration_error)
	end

	def test_page_restoration_error
		response = @app.run
		command = Command.new(response)
		command[ApplicationPage::TEST_PAGE_RESTORATION_ERROR_KEY].submit
		@app.run(command)
		assert(@app.did_page_restoration_error)
	end

	def test_handle_error
		response = @app.run
		command = Command.new(response)
		command[ApplicationPage::TEST_HANDLE_ERROR_KEY].submit
		@app.run(command)
		assert(@app.did_handle_error)
	end

end


if __FILE__ == $0 then
	suite = TestApplication.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
