if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'TestApp/app'
end

class TestAPI < Test::Unit::TestCase
	include CGIKit, CGIKit::APIUtilities

	TEST_COMPONENT = :TestAPIPage
	TEST_CLASS = :TestAPI
	TEST_KEY = :TestAPI

	def setup
		@api = API.new(TEST_CLASS)
		@hash = {:element=>TEST_CLASS}
		@hashes = {TEST_KEY => @hash}
		@api << existential_validation(:one, :another)
		@api << universal_validation(:value, :selection)
	end

	def dec
		DeclarationStore.new_from_hash(@hashes)[TEST_KEY]
	end

	def validate
		@api.validate(dec().association_hash, TEST_COMPONENT, TEST_CLASS)
	end

	def test_existential_validation_pass
		@hash[:one] = :one
		assert_nil(validate())
	end

	def test_existential_validation_competing
		@hash[:one] = :one
		@hash[:another] = :another
		assert_not_nil(validate())
	end

	def test_existential_validation_not_bound
		assert_nil(validate())
	end

	def test_universal_validation_pass
		@hash[:value] = :value
		@hash[:selection] = :selection
		assert_nil(validate())
	end

	def test_universal_validation_not_enough
		@hash[:value] = :value
		assert_not_nil(validate())
	end

	def test_universal_validation_not_bound
		assert_nil(validate())
	end

	def test_require_validation_existential_pass
		@api << required_validation([:list, :item], [], [:direct_action, :action_class])
		@hash[:list] = :list
		assert_nil(validate())
	end

	def test_require_validation_existential_not_bound
		@api << required_validation([:list, :item], [], [:direct_action, :action_class])
		assert_not_nil(validate())
	end

	def test_require_validation_existential_competing
		@api << required_validation([:list, :item], [], [:direct_action, :action_class])
		@hash[:list] = :list
		@hash[:item] = :item
		assert_not_nil(validate())
	end

	def test_require_validation_universal_not_enough
		@api << required_validation([], [:a, :b])
		@hash[:a] = :a
		assert_not_nil(validate())
	end

	def test_require_validation_universal_not_bound
		@api << required_validation([], [:a, :b])
		assert_not_nil(validate())
	end

	def test_require_validation_universal_pass
		@api << required_validation([], [:a, :b])
		@hash[:a] = :a
		@hash[:b] = :b
		assert_nil(validate())
	end

	def test_require_validation_both_with_existential_pass1
		@api << required_validation([:list], [], [:direct_action, :action_class])
		@hash[:list] = :list
		assert_nil(validate())
	end

	def test_require_validation_both_with_existential_pass2
		@api << required_validation([:list], [], [:direct_action, :action_class])
		@hash[:direct_action] = :direct_action
		assert_nil(validate())
	end

	def test_require_validation_both_with_existential_pass3
		@api << required_validation([:list], [], [:direct_action, :action_class])
		@hash[:direct_action] = :direct_action
		@hash[:action_class] = :action_class
		assert_nil(validate())
	end

	def test_require_validation_both_with_universal_pass1
		@api << required_validation([], [:list, :item], [:direct_action, :action_class])
		@hash[:list] = :list
		@hash[:item] = :item
		assert_nil(validate())
	end

	def test_require_validation_both_with_universal_pass2
		@api << required_validation([], [:list, :item], [:direct_action, :action_class])
		@hash[:direct_action] = :direct_action
		assert_nil(validate())
	end

	def test_require_validation_both_with_universal_pass3
		@api << required_validation([], [:list, :item], [:direct_action, :action_class])
		@hash[:direct_action] = :direct_action
		@hash[:action_class] = :action_class
		assert_nil(validate())
	end

	def test_require_validation_both_not_bound
		@api << required_validation([:list], [], [:direct_action, :action_class])
		assert_not_nil(validate())
	end

end



if __FILE__ == $0 then
	suite = TestAPI.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
