class RepetitionPage < CGIKit::Component
	TEST_LIST = ['Prolog', 'Smalltalk', 'Ruby', 'Objective-C']
	TEST_COUNT = TEST_LIST.size

	def list_string
		RepetitionPage.string('List', @item, index)
	end

	def count_string
		RepetitionPage.string('Count', TEST_LIST[@index], index)
	end

	def self.string( msg, object, index )
		"#{msg}: #{object} at #{index}"
	end

	def self.test_list( content )
		test_repetition('List', content)
	end

	def self.test_count( content )
		test_repetition('Count', content)
	end

	def self.test_repetition( msg, content )
		TEST_LIST.each_with_index do |item, index|
			str = string(msg, item, index)
			unless /#{str}/ === content then
				return false
			end
		end
		true
	end

end
