class ImagePage < CGIKit::Component
	TEST_SRC = 'http://.../dummy.png'
	TEST_FILE = 'cgikit.png'
	TEST_DATA = :data

	TEST_SRC_NAME = 'TestSrc'
	TEST_FILE_NAME = 'TestFile'
	TEST_DATA_NAME = 'TestData'

	def data
		application.resource_manager.bytedata(TEST_FILE)
	end

	def self.test_src( command )
		command.image(ImagePage::TEST_SRC_NAME)[:src] == TEST_SRC
	end

	def self.test_file( command )
		path = command.image(ImagePage::TEST_FILE_NAME).web_server_resource_name
		wspath = File.join(TestCommon::TESTAPP, \
			TestCommon::WEB_SERVER_RESOURCES_PATH, TEST_FILE)
		(path == TEST_FILE) and (FileTest.exist?(wspath))
	end

	def self.test_data( command )
		resource = command.image(ImagePage::TEST_DATA_NAME).resource_name
		path = File.join(TestCommon.tmp_resource_dir, resource)
		resource and FileTest.exist?(path)
	end

end
