module CGIKit

class TextField < DynamicElement
  class << self
    def create_api
      api = API.new(:TextField)
      type = Binding.new(:type)
      type.default = 'text'
      size = Binding.new(:size)
      maxlength = Binding.new(:maxlength)
      api << type
      api << size
      api << maxlength
      api << name_binding()
      api << value_binding(true, true)
      api << enabled_binding()
      set_validation(api)
      api
    end
  end

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def take_values_from_request( request, context )
    if value = value_from_request(request, context) then
      set_value(:value, value)
      validate(:value)
    end
  end

  def append_to_response( response, context )
    take_value(:value)
    take_value(:type)
    take_value(:size)
    take_value(:maxlength)

    html = "<input name=\"#{name_value(context)}\" type=\"#{@values[:type]}\""
    if @values[:value] and (@values[:type] != 'password') then
      html << " value=\"#{escaped_string(@values[:value])}\""
    end
    if @values[:size] then
      html << " size=\"#{@values[:size]}\""
    end
    if @values[:maxlength] then
      html << " maxlength=\"#{@values[:maxlength]}\""
    end
    html << other()
    html << enabled()
    html << '/>'
    response.content << html
  end
end

end
