module CGIKit

class Text < DynamicElement

  class << self
    def create_api
      api = API.new(:Text)
      api << name_binding()
      api << value_binding(true, true)
      api << enabled_binding()
      set_validation(api)
      api
    end
  end

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def take_values_from_request( request, context )
    if value = value_from_request(request, context) then
      set_value(:value, value)
      validate(:value)
    end
  end

  def append_to_response( response, context )
    take_value(:value)
    html = "<textarea name=\"#{name_value(context)}\""
    html << other()
    html << enabled()
    html << '>'
    if @values[:value] then html << escaped_string(@values[:value]) end
    html << '</textarea>'
    response.content << html
  end
end

end
