module CGIKit

class Popup < DynamicElement

  class << self
    def create_api
      api = API.new(:Popup)
      default = Binding.new(:default)
      selected_value = Binding.new(:selected_value)
      api << default
      api << selected_value
      api << name_binding()
      api << display_binding()
      api << list_binding()
      api << item_binding()
      api << escape_binding()
      api << value_binding(false, false)
      api << selection_binding()
      api << enabled_binding()
      api << item_display_value_validation()
      api << existential_validation(:selected_value, :selection)
      api
    end
  end

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def take_values_from_request( request, context )
    take_value(:list)
    if (option = value_from_request(request, context)) and \
      context.current_form?(request) then
      if declared?(:selection) then
        if option.empty? then
          selection = nil
        elsif declared?(:value)
          @values[:list].each do |item|
            set_value(:item, item)
            take_value(:value)
            if option == @values[:value].to_s then
              selection = item
              break
            end
          end
        else
          selection = @values[:list][option.to_i]
        end
        set_value(:selection, selection)
      elsif declared?(:selected_value) then
        set_value(:selected_value, option)
      end
    end
  end

  def append_to_response( response, context )
    take_value(:list)
    take_bool(:escape)
    take_value(:default)
    take_value(:selection)
    take_value(:selected_value)
    option = value_from_request(context.request, context)

    html = "<select name=\"#{name_value(context)}\""
    html << other()
    html << enabled()
    html << ">\n"

    if @values[:default] then
      html << '<option value=""'
      if @values[:selection].nil? then
        html << selected()
      end
      html << ">#{@values[:default]}</option>\n"
    end

    if @values[:list] then
      @values[:list].each_with_index do |item, index|
        set_value(:item, item)
        take_value(:value)
        take_value(:display)

        html << "<option"
        if (@values[:selection] == item) or \
          (option and !option.empty? and
            ((option == @values[:value].to_s) or \
            (option == index.to_s))) then
          html << selected()
        end
        if @values[:value] then
          value = escaped_string(@values[:value], @values[:escape])
          html << " value=\"#{value}\""
        else
          html << " value=\"#{index}\""
        end
        html << ">"

        unless display = @values[:display] then
          display = item.to_s
        end
        display = escaped_string(display, @values[:escape])
        html << "#{display}</option>\n"
      end
    end
    html << '</select>'
    response.content << html
  end
end

end
