module CGIKit

class Link < DynamicElement

  class << self
    def create_api
      api = API.new(:Link)
      page = Binding.new(:page)
      page.value_set = Binding::PAGE_NAMES
      string = Binding.new(:string)
      secure = Binding.new(:secure)
      secure.value_set = Binding::BOOLEAN
      secure.default = false
      query = Binding.new(:query)
      query.default = :'{}'

      api << action_binding()
      api << enabled_binding()
      api << href_binding()
      api << escape_binding()
      api << page
      api << string
      api << secure
      api << query
      api << session_id_binding()
      set_direct_action(api)
      api << required_validation([:action, :href, :page], [], \
        [:direct_action, :action_class])
      api
    end
  end

  def begin_context( context )
    context.increment
    context.append_zero
  end

  def end_context( context )
    context.delete
  end

  def invoke_action( request, context )
    take_value(:page)
    take_value(:action, false)
    result = nil
    if context.action?(request) then
      if @values[:page] then
        result = @application.page(@values[:page], context)
      else
        result = @root[@values[:action]]
      end
    end
    result
  end

  def append_to_response( response, context )
    take_value(:name)
    take_bool(:enabled)
    take_bool(:escape)
    take_value(:href)
    take_value(:page)
    take_value(:action, false)
    take_value(:string)
    take_bool(:secure)
    take_value(:query)
    take_value(:session_id)
    take_value(:direct_action, false)
    take_value(:action_class)

    if @values[:string] then
      @values[:string] = escaped_string(@values[:string], @values[:escape])
    end

    unless @values[:enabled] then
      if @values[:string] then
        response.content << @values[:string]
      elsif empty? == false then
        @node.append_to_response(response, context)
      end
      return
    end

    take_value_for_query_from_attributes
    if @values[:page] or @values[:action] then
      # create session if it doesn't have session
      context.session
      url = context.component_action_url(@values[:query], @values[:secure])
    elsif direct_action? then
      url = context.direct_action_url(@values[:action_class],
                                      @values[:direct_action],
                                      @values[:query],
                                      @values[:session_id])
    end

    html = '<a'
    if @values[:href] then
      html << " href=\"#{@values[:href]}\""
    else
      html << " href=\"#{url}\""
    end
    html << other()
    html << '>'

    response.content << html
    if empty? == false then
      @node.append_to_response(response, context)
    elsif @values[:string] then
      response.content << @values[:string]
    end

    response.content << '</a>'
  end

  def take_value_for_query_from_attributes
    associations.reject! do |key, as|
      if (api.has_binding?(key) == false) and (key.to_s =~ /\A\?/) then
        query_value = value(key)
        query_key = key.to_s.sub(/\A\?/, '')
        @values[:query][query_key] = query_value
        true
      else
        false
      end
    end
  end

end

end
