module CGIKit

class Image < DynamicElement

  class << self
    def create_api
      api = API.new(:Image)
      data = Binding.new(:data)
      file = Binding.new(:file)
      file.value_set = Binding::RESOURCES
      mime = Binding.new(:mime)
      mime.value_set = Binding::MIME_TYPES

      api << data
      api << file
      api << mime
      api << src_binding()
      api << required_validation([:file, :src, :data])

      api
    end
  end

  def append_to_response( response, context )
    take_value(:file)
    take_value(:src)
    take_value(:data)

    if @values[:file] then
      @values[:src] = @application.resource_manager.url(@values[:file])
    elsif @values[:data] then
      take_value(:mime)
      key = ResourceManager.create_tmp_data_key
      @application.resource_manager.set_data(@values[:data], key, @values[:mime])
      @values[:src] = @application.resource_manager.url(key, context.request)
    end

    html = "<img src=\"#{@values[:src]}\""
    html << other()
    html << '/>'
    response.content << html
  end
end

end
