module CGIKit

class Checkbox < DynamicElement

  class << self
    def create_api
      api = API.new(:Checkbox)
      api << name_binding()
      api << checked_binding()
      api << selection_binding()
      api << value_binding(false, false)
      api << enabled_binding()
      api << required_validation([:checked, :value])
      api << universal_validation(:value, :selection)
      api
    end

    def keys_to_delete_from_associations
      [:type]
    end
  end

  DEFAULT_VALUE = '1'

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def take_values_from_request( request, context )
    take_value(:value)
    take_value(:selection)
    take_bool(:checked)

    if value = value_from_request(request, context) then
      if declared?(:checked) then
        set_value(:checked, true)
      else
        set_value(:selection, @values[:value])
      end
    elsif context.current_form?(request) then
      if declared?(:checked) then
        if @values[:checked] == true then
          set_value(:checked, false)
        end
      else
        if @values[:value] == @values[:selection] then
          set_value(:selection, nil)
        end
      end
    end
  end

  def append_to_response( response, context )
    take_value(:value)
    take_value(:selection)
    take_bool(:checked)

    html =  "<input type=\"checkbox\" name=\"#{name_value(context)}\""
    html << %Q' value="#{escaped_string(@values[:value]) || DEFAULT_VALUE}"'
    html << other()
    if declared?(:checked) then
      if @values[:checked] == true then
        html << checked()
      end
    elsif @values[:selection] and (@values[:value] == @values[:selection]) then
      html << checked()
    end
    html << enabled()
    html << '/>'
    response.content << html
  end
end

end
