module CGIKit

class Browser < DynamicElement

  class << self
    def create_api
      api = API.new(:Browser)
      multiple = Binding.new(:multiple)
      multiple.value_set = Binding::BOOLEAN
      multiple.default = true
      api << multiple
      api << name_binding()
      api << display_binding()
      api << list_binding()
      api << item_binding()
      api << escape_binding()
      api << value_binding(false, false)
      api << selections_binding()
      api << selected_values_binding()
      api << enabled_binding()
      api << item_display_value_validation()
      api << existential_validation(:selected_values, :selections)
      api
    end

    def keys_to_delete_from_associations
      [:type]
    end
  end

  def begin_context( context )
    take_value(:name)
    context.increment(@values[:name])
  end

  def take_values_from_request( request, context )
    take_value(:list)
    take_value(:selections)
    take_value(:selected_values)
    names = [:selections, :selected_values]
    names.each do |name|
      if @values[name].nil? then
        @values[name] = []
        set_value(name, @values[name])
      end
    end

    options = values_from_request(request, context)
    if !options.empty? and context.current_form?(request) then
      if declared?(:selections) then
        @values[:selections].clear
        if declared?(:value) then
          @values[:list].each do |item|
            set_value(:item, item)
            take_value(:value)
            if options.include?(@values[:value].to_s) then
              @values[:selections] << item
            end
          end
        else
          options.each do |option|
            @values[:selections] << @values[:list][option.to_i]
          end
        end
      elsif declared?(:selected_values) then
        @values[:selected_values].replace(options)
      end
    end
  end

  def append_to_response( response, context )
    take_value(:list)
    take_value(:selections)
    take_value(:selected_values)
    take_bool(:escape)
    take_bool(:multiple)
    options = values_from_request(context.request, context)

    html = "<select name=\"#{name_value(context)}\""
    if @values[:multiple] then html << ' multiple="multiple"' end
    html << other()
    html << enabled()
    html << ">\n"

    if @values[:list] then
      @values[:list].each_with_index do |item, index|
        set_value(:item, item)
        take_value(:value)
        take_value(:display)

        html << "<option"
        if (@values[:selections] and @values[:selections].include?(item)) or \
          (options and 
             (options.include?(@values[:value].to_s) or \
              options.include?(index.to_s))) then
          html << " selected=\"selected\""
        end
        if @values[:value] then
          value = escaped_string(@values[:value], @values[:escape])
          html << " value=\"#{value}\""
        else
          html << " value=\"#{index}\""
        end
        html << ">"

        unless display = @values[:display] then
          display = item.to_s
        end
        display = escaped_string(display, @values[:escape])
        html << "#{display}</option>\n"
      end
    end
    html << '</select>'
    response.content << html
  end
end

end
