module CGIKit

  # Shows an error page when catches an exception.
  class CKErrorPage < Component

    attr_accessor :error, :validation_error_element

    def version
      CGIKit::VERSION
    end

    def error_class
      @error.class
    end

    def reason
      @error.message
    end

    def backtrace
      @error.backtrace
    end

    def warning?
      @warning
    end

    def validation_error?
      ValidationError === @error
    end

  end

end

