module CGIKit

# Classes under Adapter are interface between CGIKit and web servers.
# 
# The role of adapter is to provide the consistent interface to 
# Application. The difference of the relationship between 
# CGIKit and a web server is aboserbed by the obejct. 
module Adapter
  class CGI
    attr_accessor :headers, :params
    attr_reader :input, :output, :error

    CR  = "\r"
    LF  = "\n"
    EOL = CR + LF

    def initialize
      @headers = ENV
      @input   = $stdin
      @output  = $stdout
      @error   = $stderr
      @params = Utilities.query_from_headers(@headers, @input)
    end

    def create_request
      Request.new(headers, params)
    end

    def create_response
      Response.new(headers)
    end

    def run( request, response, &block )
      request ||= create_request

      if block_given?
        response = block.call(request)
      end

      print response.header
      print response.to_s
    end

  end


  class ModRuby < CGI
    def run( request, response, &block )
      request ||= create_request

      if block_given?
        response = block.call(request)
      end

      # import from cgi.rb
      r = Apache.request
      table = r.headers_out
      response.header.scan(/([^:]+): (.+)#{EOL}/n){ |name, value|
        case name
        when 'Set-Cookie'
          table.add(name, value)
        when /^status$/ni
          r.status_line = value
          r.status = value.to_i
        when /^content-type$/ni
          r.content_type = value
        when /^content-encoding$/ni
          r.content_encoding = value
        when /^location$/ni
          if r.status == 200
            r.status = 302
          end
          r.headers_out[name] = value
        else
          r.headers_out[name] = value
        end
      }
      r.send_http_header

      print response.to_s
    end
  end


  class Template < CGI
    def initialize
      require 'stringio'
      @headers = ENV
      @input   = StringIO.new
      @output  = StringIO.new
      @error   = StringIO.new
      @params  = Hash.new([])
    end

    def run( request, response, &block )
      request ||= create_request

      if block_given?
        response = block.call(request)
      end

      response
    end
  end

end

end



