#!/usr/bin/env ruby

# copyright (C) 2004- Shinya Kawaji.
# It is a free software distributed under the Ruby license.
# 
# webrick-app.rb [component_path [port]]

$LOAD_PATH.unshift('../../../lib')

require 'webrick'
require 'cgikit'
require 'cgikit/webrick'

require 'blog'
require 'DiaryPost'

path = ARGV.shift || Dir.pwd
port = (ARGV.shift || 8080).to_i

app = CGIKit::Application.new
app.direct_action_class = DiaryAction
app.default_request_handler = app.direct_action_request_handler

app2 = CGIKit::Application.new
app2.main = DiaryPost

server = WEBrick::HTTPServer.new({:Port => port})
server.mount('/blog.rb', WEBrick::CGIKitServlet::ApplicationHandler, app)
server.mount('/DiaryPost.rb', WEBrick::CGIKitServlet::ApplicationHandler, app2)
server.mount('/', WEBrick::HTTPServlet::FileHandler, './')


trap("INT"){ server.shutdown }
server.start
