module Examples

  class SourcePage < CGIKit::Component

    attr_accessor :source

    def body( suffix )
      base = basename(@source)
      if /ja/ === request.languages[0] and suffix == 'html' then
        file = "./components/#{base}_ja.#{suffix}"
      else
        file = "./components/#{base}.#{suffix}"
      end
      File.new(file).readlines.join
    end

    def basename( klass )
      klass.to_s.split('::').last
    end
      
    def html_source
      body("html")
    end

    def declaration_source
      body("ckd")
    end

    def ruby_source
      body("rb")
    end

  end

end
