#!/usr/bin/env ruby

# webrick-app.rb [port]

$LOAD_PATH.unshift('../../lib')
require 'webrick'
require 'cgikit'
require 'cgikit/webrick'
require 'logger'

port = (ARGV.shift || 8080).to_i

app = CGIKit::Application.new
app.load_all_components('./components')
app.component_paths << 'components'

def app.log_options=(opt)
  @log_options = opt
end

def app.log_options
  @log_options
end

app.log_options = {'name' => 'ErrorScreen', 'max_file_size' => 8192,  'file' => 'log.txt'}

server = WEBrick::HTTPServer.new({:Port => port})
server.mount('/', WEBrick::CGIKitServlet::ApplicationHandler, app)

trap("INT"){ server.shutdown }
server.start
