class MainPage < CGIKit::Component

  def init
    @buffers = [0]
    @history = []
  end


  #
  # action
  #

  def plus; add_operator(:+); end
  def minus; add_operator(:-); end
  def times; add_operator(:*); end
  def divide; add_operator(:/); end

  def add_0; add_buffer(0); end
  def add_1; add_buffer(1); end
  def add_2; add_buffer(2); end
  def add_3; add_buffer(3); end
  def add_4; add_buffer(4); end
  def add_5; add_buffer(5); end
  def add_6; add_buffer(6); end
  def add_7; add_buffer(7); end
  def add_8; add_buffer(8); end
  def add_9; add_buffer(9); end

  def equal
    calc
  end


  #
  # calculating
  #

  def add_operator( operator )
    if last_operation_operator? then
      @buffers.pop
    end
    @buffers << operator
  end

  def add_buffer( digit )
    last = @buffers.pop
    if Numeric === last then
      @buffers << "#{last}#{digit}".to_i
    else
      @buffers << last
      @buffers << digit
    end
  end

  def calc
    if !last_operation_operator? and (@buffers.size > 1) then
      statement = buffer_string.dup
      result = eval(statement)
      @buffers.clear
      @buffers << result
      expr = "#{statement} = #{result}"
      record(expr)
    end
  end

  def last_operation_operator?
    [:+, :-, :*, :/].include?(@buffers.last)
  end

  def record( expression )
    @history << expression
  end

  def clear
    @buffers.clear
    @buffers << 0
  end


  #
  # displaying
  #

  def buffer_string
    @buffers.join(' ')
  end

end
