#!/usr/local/bin/ruby

# webrick-app.rb [port]

$LOAD_PATH.unshift('../../lib')

require 'webrick'
require 'cgikit'
require 'cgikit/lang/ja'
require 'cgikit/webrick'
require 'lib/app'
require 'lib/session'
require 'lib/context'
require 'lib/directaction'
require 'lib/wikipage'
require 'lib/renderer'
require 'lib/utilities'
require 'lib/index'
require 'HeaderParts'
require 'MainPage'
require 'EditPage'
require 'UploadPage'
require 'ListPage'
require 'RecentPage'
require 'NotifyPage'
require 'SearchPage'


port = (ARGV.shift || 8080).to_i

app = CKWiki::Application.new

# document root
#app.document_root = '/d/cgikit/examples/CKWiki'
app.document_root = '.'

# resource directory includes wiki pages and indexes.
app.resources = 'resources'

# web server resource directory include uploaded file and style sheet.
#app.web_server_resources = '/d/cgikit/examples/CKWiki/webresources'
app.web_server_resources = './webresources'

# wiki name used as title.
app.wikiname = 'CKWiki'

# style sheet. specify resource name, not path.
app.css = 'ckwiki.css'

# length of summary in search page.
app.summary_length = 160

app.validate_api = false

server = WEBrick::HTTPServer.new({:Port => port})
server.mount('/', WEBrick::CGIKitServlet::ApplicationHandler, app)
server.mount('/webresources', WEBrick::HTTPServlet::FileHandler, './webresources')

trap("INT"){ server.shutdown }
server.start
