module CKWiki

class WikiPage

  attr_accessor :name, :content, :last_updated, :new_page
  alias new_page? new_page

  def self.new_with_resource_manager( name, resource_manager )
    content = resource_manager.string(name)
    page = new(name, content)
    if path = resource_manager.path(name) then
      open(path) do |f|
        page.last_updated = f.mtime
      end
      page.new_page = false
    end
    page
  end

  def initialize( name, content = nil )
    @name = name
    @content = content || ''
    @last_updated = Time.new
    @new_page = true
  end

  def to_html( context )
    renderer = HTMLRenderer.new(self, context)
    renderer.render
  end

  def write( resource_manager )
    resource_manager.write_resource(@name, @content)
  end

  def summary_if_match( keywords, length )
    keywords.each do |keyword|
      pattern = /#{keyword}/im
      if (index = @content.index(pattern)) != nil then
        start_index = summary_start_index(index, length)
        end_index = summary_end_index(index, length)
        summary = @content[start_index...end_index]
        return summary
      end
    end
    nil
  end

  def summary_start_index( index, length )
    index = index - (length / 2)
    if index < 0 then
      index = 0
    end
    index
  end

  def summary_end_index( index, length )
    index + (length / 2)
  end

end

end
