module CKWiki

module Utilities
  attr_accessor :page_name

  RFC822_DAYS = %w[ Sun Mon Tue Wed Thu Fri Sat ]
  RFC822_MONTHS = %w[ Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ]

  def wiki_page( name = @page_name )
    @wiki_page ||= application.wiki_page(name)
  end

  def front_page
    @front_page ||= application.wiki_page(FRONT_PAGE)
  end

  def display_page_with_name( name )
    page = page(MainPage)
    page.init_display_page(name)
    page
  end

  def rfc1123_date( time )
    t = time.clone.gmtime
    format("%s, %.2d %s %.4d %.2d:%.2d:%.2d GMT",
           RFC822_DAYS[t.wday], t.day, RFC822_MONTHS[t.month-1], t.year,
           t.hour, t.min, t.sec)
  end

  module_function :rfc1123_date

end

end
