module CKWiki

class DirectAction < CGIKit::DirectAction
  include CGIKit::Utilities

  NAME_KEY = 'wikiname'

  def display_action
    name = @request.form_value(NAME_KEY)
    page = page(MainPage)
    page.page_name = name
    page
  end

  def edit_action
    name = @request.form_value(NAME_KEY)
    page = page(EditPage)
    page.init_editing_page(name)
    page
  end

  def recent_action
    page(RecentPage)
  end

  def front_action
    page(FrontPage)
  end

  def list_action
    page(ListPage)
  end

  def rss_action
    wikiname = escape_html(application.wikiname)
    recent_uri = context.recent_url
    last_modified = nil
    if last_recent = application.recent_index.items[0] then
      last_modified = last_recent.date
      date = last_modified.utc.strftime("%Y-%m-%dT%H:%M:%S+00:00")
      date = "<dc:date>#{date}</dc:date>"
    else
      date = nil
    end
    items = <<EOS
<?xml version="1.0" encoding="utf-8"?>
<rdf:RDF
  xmlns="http://purl.org/rss/1.0/"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <channel rdf:about="#{recent_uri}">
    <title>#{wikiname}</title>
    <link>#{recent_uri}</link>
    <description>#{wikiname}</description>
    <language>#{application.lang}</language>
    #{date}
    <items>
      <rdf:Seq>
EOS

    num = application.rss_page_number
    n = 0
    item_list = ''
    application.recent_index.each do |index|
      break if (n += 1) > num
      name = index.name
      items << '        '

      uri = "#{application.default_request_handler.application_path(@request)}?#{name}"
      items << %Q!<rdf:li resource="#{uri}"/>!

      item_list << <<EOS
    <item rdf:about="#{uri}">
    <title>#{escape_html(name)}</title>
    <link>#{uri}</link>
    <dc:date>#{last_modified.utc.strftime("%Y-%m-%dT%H:%M:%S+00:00")}</dc:date>
  </item>
EOS
    end

    items << <<EOS
      </rdf:Seq>
    </items>
  </channel>
EOS

    items << item_list << '</rdf:RDF>'

    response = CGIKit::Response.new
    header = response.headers
    header['Last-Modified'] = Utilities.rfc1123_date(last_modified) if last_modified
    header['type']          = 'text/xml'
    header['charset']       = 'utf-8'
    header['Content-Language'] = application.lang
    header['Pragma']           = 'no-cache'
    header['Cache-Control']    = 'no-cache'
    response.content = Uconv.euctou8(items)
    response
  end

end

end
