module CKWiki

  class CVSEntryStore

    def initialize( path )
      require 'time'
      @entries = {}
      file = File.join(path, 'CVS', 'Entries')
      open(file) do |f|
        f.readlines.each do |line|
          line.chomp!
          next if /\AD\// === line or /\AD\Z/ === line
          /\/([^\/]*)\/([\.0-9]*)\/([^\/]*)\// === line
          name = $1
          rev = CVSRevision.new($2)
          begin
            time = Time.parse($3)
          rescue
            time = nil
          end
          @entries[name] = CVSEntry.new(name, rev, time)
        end
      end
    end

    def entry( name )
      @entries[name]
    end

  end


  class CVSEntry

    attr_accessor :name, :revision, :last_updated

    def initialize( name, revision, last_updated )
      @name = name
      @revision = revision
      @last_updated = last_updated
    end

  end


  class CVSRevision

    attr_accessor :digits

    def initialize( rev = nil )
      @digits = []
      if rev then
        rev.split('.').each do |digit|
          @digits << digit.to_i
        end
      end
    end

    def number
      @digits.last
    end

    def next_revision
      digits = @digits.dup
      digits.last.succ
      rev = self.class.new
      rev.digits = digits
      rev
    end

    def pre_revision
      digits = @digits.dup
      last = digits.pop
      last -= 1
      digits << last
      rev = self.class.new
      rev.digits = digits
      rev
    end

    def to_s
      @digits.join('.')
    end

  end

end

