module CKWiki

  class SearchPage < CGIKit::Component
    include Utilities

    Struct.new('SearchResult', :name, :summary)

    def search( keyword = @keyword )
      @results = []
      keywords = keywords_by_splitting(keyword)
      if keywords.empty? then return end

      index = application.page_index
      length = application.summary_length
      index.each do |item|
        name = item.name
        wiki = application.wiki_page(name)
        if summary = wiki.summary_if_match(keywords, length) then
          add_result(name, summary)
        end
      end
    end

    def keywords_by_splitting( keyword )
      keyword.split(/\s+/)
    end

    def add_result( name, summary )
      result = Struct::SearchResult.new(name, summary)
      @results << result
    end

    def has_results?
      !@results.empty?
    end

    def hits
      @results.size
    end

    def page_name
      @result.name
    end

    def summary
      @result.summary
    end

    def display_page
      display_page_with_name(page_name())
    end

  end

end
