module CKWiki

  class MainPage < CGIKit::Component
    include Utilities

    def init
      @page_name = FRONT_PAGE
      unless (name = request.query_string).empty? then
        @page_name = name
      end
    end

    def init_display_page( name )
      @page_name = name
    end

    def render_wiki_page
      wiki_page.to_html(context)
    end

    def links_top
      @page_name != FRONT_PAGE
    end

    def links_help
      @page_name != HELP_PAGE
    end

    def last_updated
      if application.cvs? then
        entry = application.entry_store.entry(@page_name)
        time = time_format(entry.last_updated)
        "#{time}; rev #{entry.revision}"
      else
        time_format(wiki_page.last_updated)
      end
    end

    def time_format( time )
      time.localtime
      time.strftime("%Y/%m/%d (%a) %H:%M:%S %Z")
    end

    def display_url
      "#{application.baseurl}?#{@page_name}"
    end

    def invoke_action( request, context )
      if wiki_page.new_page? then
        page = page(EditPage)
        page.init_editing_page(@page_name)
        page
      else
        super
      end
    end

    def inverse_pages
      application.inverse_page_index.inverse_page_names(@page_name)
    end

    def display_inverse_page
      page = page(MainPage)
      page.page_name = @inverse_page
      page
    end

  end

end
