module CKWiki

class EditPage < CGIKit::Component
  include Utilities

  attr_accessor :editing_content

  def init_editing_page( name )
    @editing_page = application.wiki_page(name)
    @original = @editing_page.content.dup
  end

  def display_preview
    @preview = true
  end

  def preview_content
    @editing_page.to_html(context)
  end

  def save_changes
    unless validate then
      @conflict = true
      return
    end

    recent = application.recent_index
    recent.add(@editing_page)
    list = application.page_index
    list.add(@editing_page)
    recent.write
    list.write
    @editing_page.write(resource_manager)
    inverse = application.inverse_page_index
    inverse.update

    if application.cvs? then
      cvserror = nil
      oldpwd = Dir.pwd
      begin
        Dir.chdir(application.resources)
        system("#{application.cvspath} add #{@editing_page.name} > /dev/null 2>&1")
        ci = system("#{application.cvspath} ci -m '#{request.remote_addr} - #{request.remote_host}' > /dev/null 2>&1")
        unless ci then
          cvserror = "commit failed"
        end
      rescue Exception => e
          cvserror = "commit failed: #{e.message}"
      ensure
        Dir.chdir(oldpwd)
      end
    end

    notify = page(NotifyPage)
    notify.init_display_page(@page_name)
    notify.cvserror = cvserror if application.cvs?
    notify
  end

  def validate
    @original == application.wiki_page(@editing_page.name).content
  end
end

end
