module CKWiki

  class DiffPage < CGIKit::Component

    attr_reader :page_name

    def page_name=( name )
      @entry = application.entry_store.entry(name)
      @page_name = name
    end

    def diff
      content = nil
      oldpwd = Dir.pwd
      begin
        rev = @entry.revision.pre_revision
        Dir.chdir(application.resources)
        content = %x(#{application.cvspath} -Q diff -c -r #{rev} #{@page_name})
      ensure
        Dir.chdir(oldpwd)
      end
      content
    end
  end

end
