unit Dice_test;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label2: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;
const
  N = 624;
  M = 397;
  MATRIX_A:Longword = $9908b0df;   //* constant vector a */
  UPPER_MASK:Longword = $80000000; //* most significant w-r bits */
  LOWER_MASK:Longword = $7fffffff; //* least significant r bits */

var
  Form1: TForm1;
  mt:array[0..N-1] of LongWord; //* the array for the state vector  */
  mti:Integer=N+1; //* mti==N+1 means mt[N] is not initialized */
  math:array[0..5] of Integer=(0,0,0,0,0,0);
  total:Integer=0;



implementation

{$R *.dfm}

procedure init_genrand(s:LongWord);
var
  i:Integer;
begin
  for i := 0 to N - 1 do
  begin
    mt[i] := s and $ffff0000;

    s  := 69069 * s + 1;

    mt[i] := mt[i] or ((s and $ffff0000) shr 30);

    s  := 69069 * s + 1;

  end;
  mti := N;

end;

function genrand_int32():LongWord;
const
  mag01:array[0..1] of LongWord = ($0, $9908b0df);
var
  y:LongWord;
  kk:Integer;
begin
    if mti >= N then
    begin
        if mti = N+1 then
        begin
            init_genrand(LongWord(5489));
        end;
        for kk:=0 to N-M-1 do
        begin
            y := (mt[kk] and UPPER_MASK) or (mt[kk+1] and LOWER_MASK);
            mt[kk] := mt[kk+M] xor (y shr 1) xor mag01[y and LongWord($1)];
        end;
        for kk:=N-M to N-2 do
        begin
            y := (mt[kk] and UPPER_MASK) or (mt[kk+1] and LOWER_MASK);
            mt[kk] := mt[kk+(M-N)] xor (y shr 1) xor mag01[y and LongWord($1)];
        end;
        y := (mt[N-1] and UPPER_MASK) or (mt[0] and LOWER_MASK);
        mt[N-1] := mt[M-1] xor (y shr 1) xor mag01[y and LongWord($1)];

        mti := 0;
    end;

    y := mt[mti];
    Inc(mti);
    y := y xor (y shr 11);
    y := y xor (y shl 7) and LongWord($9d2c5680);
    y := y xor (y shl 15) and LongWord($efc60000);
    y := y xor (y shr 18);

    Result := y;
end;
 procedure reset_Dice();
var i:integer;
begin
  for i:=0 to 5 do
  math[i]:=0;
  total:=0;
 Form1.Label1.Caption:='Dice:'+IntToStr(i)+' Total:'+IntToStr(total)+':'+' Times:'+IntToStr(math[i-1]);
 Form1.Label3.Width:=0;
 Form1.Label4.Width:=0;
 Form1.Label5.Width:=0;
 Form1.Label6.Width:=0;
 Form1.Label7.Width:=0;
 Form1.Label8.Width:=0;
end;
procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
  init_genrand(Random(1000));
  reset_Dice();
end;

procedure Dice();
var i:Integer;
begin
 i:=genrand_int32() mod 6 +1;
 Inc(math[i-1]);
 inc(total);
 Form1.Label1.Caption:='Dice:'+IntToStr(i)+' Total:'+IntToStr(total)+':'+' Times:'+IntToStr(math[i-1]);
 Form1.Label3.Width:=Trunc(math[0]/total*500);
 Form1.Label3.Caption:=IntToStr(Trunc(math[0]/total*100))+'%';
 Form1.Label4.Width:=Trunc(math[1]/total*500);
 Form1.Label4.Caption:=IntToStr(Trunc(math[1]/total*100))+'%';
 Form1.Label5.Width:=Trunc(math[2]/total*500);
 Form1.Label5.Caption:=IntToStr(Trunc(math[2]/total*100))+'%';
 Form1.Label6.Width:=Trunc(math[3]/total*500);
 Form1.Label6.Caption:=IntToStr(Trunc(math[3]/total*100))+'%';
 Form1.Label7.Width:=Trunc(math[4]/total*500);
 Form1.Label7.Caption:=IntToStr(Trunc(math[4]/total*100))+'%';
 Form1.Label8.Width:=Trunc(math[5]/total*500);
 Form1.Label8.Caption:=IntToStr(Trunc(math[5]/total*100))+'%';
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
     Dice();
end;

procedure TForm1.Button2Click(Sender: TObject);
var i:Integer;
begin
  for i:=0 to 9 do
  Dice();
end;

procedure TForm1.Button3Click(Sender: TObject);
var i:Integer;
begin
  for i:=0 to 99 do
  Dice();
end;

procedure TForm1.Button4Click(Sender: TObject);
var i:Integer;
begin
  for i:=0 to 999 do
  Dice();
end;



procedure TForm1.Button5Click(Sender: TObject);
begin
  reset_Dice;
end;

end.
