package MyMain;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;

import Cameus.CameusLock;
import Cameus.KameusThread;
import MyCanvas.GameCanvas.GameTimer;

import com.sun.j3d.utils.geometry.*;        //Primitive

public class ChangeCanvasThread implements Runnable{

	Thread thread;
	CameraPointingGame cameraPointingGame;
	String command;
	Cursor cursor;
	public ChangeCanvasThread(CameraPointingGame cameraPointingGame,String command){
		this.cameraPointingGame = cameraPointingGame;
		this.command = command;
	}
	
	public void threadStart(){
		
    	thread = new Thread(this);
    	thread.start();
    	
		System.out.println("ChangeCanvasThread is Open");
	}
	
	public void run(){
		
		System.out.println("ChangeCanvasThread is Running");
		
		if (command.compareTo("changeClearCanvas") == 0){
			System.out.println(this.command + "Start");
			
			removeCanvas();
			stopMusic();
			//stopCameus();
			
	    	cameraPointingGame.frame.add(cameraPointingGame.canvasClearGame.canvas,BorderLayout.CENTER);
	    		 
	    	//NA[^Cݒ
			String timeStr = String.valueOf(GameTimer.clearTime);
	    	((Text2D)(MyCanvas.ClearCanvas.ClearCanvas.timeTFG.getChild(0)))
	    	.setString(TextData.CLEAR_TIME + " " + timeStr + TextData.CLEAR_SEC);
	    	
	    	cameraPointingGame.frame.invalidate();
	    	cameraPointingGame.frame.validate();
		}
		else if (command.compareTo("changeStartCanvas") == 0){
			
			System.out.println(this.command + "Start");
			
			removeCanvas();
			stopMusic();
			//stopCameus();
			
	    	cameraPointingGame.frame.add(cameraPointingGame.canvasStartView.canvas,BorderLayout.CENTER);
	    		    	
	    	cameraPointingGame.frame.invalidate();
	    	cameraPointingGame.frame.validate();
	    	
	    	this.cameraPointingGame.canvasStartView.myStartCanvasSound.musicPlay();
	    	
	    	
			System.out.println(this.command + "End");
		}
		else if (command.compareTo("chanageKaisetsuCanvas") == 0){
			
			System.out.println(this.command + "Start");
			
			removeCanvas();
			stopMusic();
			//stopCameus();
			
	    	cameraPointingGame.frame.add(cameraPointingGame.canvasKaisetsuView.canvas,BorderLayout.CENTER);
	    	
	    	/*try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				// TODO ꂽ catch ubN
				e.printStackTrace();
			}*/
	    	startCameus();
	        Toolkit toolkit = Toolkit.getDefaultToolkit();
	        Image image = toolkit.getImage("res/test.gif");

	        cursor = toolkit.createCustomCursor(image, new Point(16, 16), "test");

	        cameraPointingGame.frame.setCursor(cursor);
	    	
	    	cameraPointingGame.frame.invalidate();
	    	cameraPointingGame.frame.validate();	
	    	

			System.out.println(this.command + "End");
		}	
		else if (command.compareTo("changeEndingCanvas") == 0){
			
			System.out.println(this.command + "Start");
			
			removeCanvas();
			stopMusic();
			//stopCameus();
			
	    	cameraPointingGame.frame.add(cameraPointingGame.canvasEndingView.canvas,BorderLayout.CENTER);
	    	
	    	cameraPointingGame.frame.invalidate();
	    	cameraPointingGame.frame.validate();
	    	
			System.out.println(this.command + "End");
		}	
		else if (command.compareTo("changeGameCanvas") == 0){
			
			System.out.println(this.command + "Start");
			removeCanvas();
			stopMusic();
			//stopCameus();
			
			
	    	cameraPointingGame.frame.add(cameraPointingGame.canvasGameView.canvas,BorderLayout.CENTER);
	    	
	    		    	
	    	cameraPointingGame.frame.invalidate();
	    	cameraPointingGame.frame.validate();
	    	
	    	this.cameraPointingGame.canvasGameView.myGameCanvasSound.musicPlay();
	    	
			System.out.println(this.command + "End");
		}	
		
		else if (command.compareTo("changeLoadingCanvas") == 0){
			
			System.out.println(this.command + "Start");
			removeCanvas();
			//stopCameus();
			//stopMusic();
			
	    	cameraPointingGame.frame.add(cameraPointingGame.loadingView.canvas,BorderLayout.CENTER);
	    		    
	    		    	
	    	cameraPointingGame.frame.invalidate();
	    	cameraPointingGame.frame.validate();
	    	
			System.out.println(this.command + "End");
		}	
	}
	
	public void removeCanvas(){
	
		//cameraPointingGame.frame.setCursor(new Cursor(Cursor.WAIT_CURSOR));
		
		try {
			cameraPointingGame.frame.remove(cameraPointingGame.canvasGameView.canvas);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			cameraPointingGame.frame.remove(cameraPointingGame.canvasClearGame.canvas);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			cameraPointingGame.frame.remove(cameraPointingGame.canvasStartView.canvas);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			cameraPointingGame.frame.remove(cameraPointingGame.canvasKaisetsuView.canvas);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			cameraPointingGame.frame.remove(cameraPointingGame.canvasEndingView.canvas);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			cameraPointingGame.frame.remove(cameraPointingGame.loadingView.canvas);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void stopMusic(){
	
		try {
			this.cameraPointingGame.canvasStartView.myStartCanvasSound.musicStop();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {	
			this.cameraPointingGame.canvasGameView.myGameCanvasSound.musicStop();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void stopCameus(){
		CameusLock.resetIsCameus();		
		
	}
	
	public void startCameus(){
		CameusLock.setIsCameus();
		
    	//JXJn
    	KameusThread kamesThread = new KameusThread(this.cameraPointingGame);
        kamesThread.startThread();        
	}
}