package MyCanvas.GameCanvas;


import java.awt.event.*;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Robot;
import java.util.Enumeration;               //Enumeration

import javax.media.j3d.*;                   //Java3d

import MyMain.CameraPointingGame;

public class GameCanvasBehavior extends Behavior{

    private WakeupCondition wakeupConditon;
    CameraPointingGame cameraPointingGame;

    public GameCanvasBehavior(){
    }

    public void initialize(){

        WakeupCriterion[] event = new WakeupCriterion[2];
        event[0] = new WakeupOnElapsedFrames(0);
        event[1] = new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED);
        wakeupConditon = new WakeupOr(event);
        wakeupOn(wakeupConditon);
    }

    @SuppressWarnings("rawtypes")
	public void processStimulus(Enumeration enumeration){

        WakeupCriterion event;
        AWTEvent[] awtEvent;

        while(enumeration.hasMoreElements()){
            event = (WakeupCriterion)enumeration.nextElement();
            if(event instanceof WakeupOnAWTEvent){
                awtEvent = ((WakeupOnAWTEvent)event).getAWTEvent();
                processMyKeyEvent(awtEvent);
            }else if(event instanceof WakeupOnElapsedFrames){
                processMyFrameEvent();
            }
        }
        wakeupOn(wakeupConditon);
    }

    private void processMyKeyEvent(AWTEvent[] event){

        for(int i=0; i<event.length; i++){
            if(((KeyEvent)(event[i])).getID()==KeyEvent.KEY_PRESSED){
                switch(((KeyEvent)(event[i])).getKeyCode()){
                    case KeyEvent.VK_SPACE:
                        System.out.println("VK_SPACE");
                    	try {
                			Robot robot = new Robot();
                			robot.mousePress(InputEvent.BUTTON1_MASK);
                			robot.mouseRelease(InputEvent.BUTTON1_MASK);
                		} catch (AWTException e) {
                			// TODO ꂽ catch ubN
                			e.printStackTrace();
                		}
                        break;
                    case KeyEvent.VK_ESCAPE:
                        System.out.println("VK_ESCAPE");
                        try{
                        Cameus.KameusThread.capture.release();
                        }
                        catch (Exception e){
                        }
                        System.exit(0);
                        break;
                }
            }
        }
    }

    private void processMyFrameEvent(){
    }
}