package MyCanvas.GameCanvas;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Random;

import javax.media.j3d.*;                   //Java3d
import javax.vecmath.AxisAngle4f;

import com.sun.j3d.utils.image.TextureLoader;

public class AutoTurnEnemy  implements Runnable{
	
	Thread thread;
	TransformGroup tfg;
	Transform3D tfd;
	public static int time = 60;
	public CpLock cpLock;
	public Shape3D shape3D;
	public EnemyData enemy;
	
	public AutoTurnEnemy(Transform3D tf3d, TransformGroup tfg, CpLock cpLock, Shape3D shape3D,
			EnemyData enemy){
    	this.tfd = tf3d;
    	this.tfg = tfg;
    	this.cpLock = cpLock;
        this.shape3D = shape3D;
        this.enemy = enemy;
    	thread = new Thread(this);
    	thread.start();
	}
	
	public void autoTurnStart(){

	}
	
	public void autoTurnStop(){
	
		time = 60;
		
	}

	public void run(){
		
		while(true){
			
			for(int count = 0 ; count < FiveRoundData.getTurnNum(); count+=1){
			
				if (this.cpLock.getIsTurn() == true){
					break;
				}
				
				try {
					Thread.sleep(10);
				} catch (InterruptedException e) {
					// TODO ꂽ catch ubN
					e.printStackTrace();
				}
			}
			
			if (this.cpLock.getIsTurn() == true){
				continue;
			}
			//]Jn
			this.cpLock.setIsTurn();
		    
			for (int r = 1; r < 4; r += 1) {
				for (int x = 1; x < 6; x += 1) {
					tfd.setRotation(new AxisAngle4f(0.8f, 0.0f, 0.0f,
							(float) (Math.PI / (0.1f * x))));
					tfg.setTransform(tfd);

					try {
						Thread.sleep(100); // 100~bSleep
					} catch (InterruptedException e) {
					}
				}
			}
			
	        Toolkit toolkit = Toolkit.getDefaultToolkit();
	        
	        Random rnd = new Random();

	        int ran = rnd.nextInt(5);
	        enemy.enemyNum = ran;
	        Image image = toolkit.getImage("res/" + String.valueOf(ran) + ".png");
	        TextureLoader loader = new TextureLoader(image, null);
	    	
	        shape3D.getAppearance().setTexture(loader.getTexture());
	        
			//]I
			this.cpLock.resetIsTurn();
			
		}
	}
}