package MyCanvas.EndingCanvas;


import java.awt.event.*;
import java.awt.AWTEvent;
import java.util.Enumeration;               //Enumeration

import javax.media.j3d.*;                   //Java3d

import MyMain.CameraPointingGame;

public class EndingCanvasBehavior extends Behavior{

    private WakeupCondition wakeupConditon;
    CameraPointingGame cameraPointingGame;

    public EndingCanvasBehavior(TransformGroup tg,CameraPointingGame cameraPointingGame){

    	this.cameraPointingGame = cameraPointingGame;
    }

    public void initialize(){

        WakeupCriterion[] event = new WakeupCriterion[2];
        event[0] = new WakeupOnElapsedFrames(0);
        event[1] = new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED);
        wakeupConditon = new WakeupOr(event);
        wakeupOn(wakeupConditon);
    }

    @SuppressWarnings("rawtypes")
	public void processStimulus(Enumeration enumeration){

        WakeupCriterion event;
        AWTEvent[] awtEvent;

        while(enumeration.hasMoreElements()){
            event = (WakeupCriterion)enumeration.nextElement();
            if(event instanceof WakeupOnAWTEvent){
                awtEvent = ((WakeupOnAWTEvent)event).getAWTEvent();
                processMyKeyEvent(awtEvent);
            }
        }
        wakeupOn(wakeupConditon);
    }

    private void processMyKeyEvent(AWTEvent[] event){

        for(int i=0; i<event.length; i++){
            if(((KeyEvent)(event[i])).getID()==KeyEvent.KEY_PRESSED){
                switch(((KeyEvent)(event[i])).getKeyCode()){
                    case KeyEvent.VK_ENTER:
                        System.out.println("SpaceKey pressedxStartCanvasBehavior");
                        cameraPointingGame.changeGameCanvas();;
                        break;
                    case KeyEvent.VK_ESCAPE:
                        System.out.println("Esc pressedxStartCanvasBehavior");
                        System.out.println("VK_ESCAPE");
                        try{
                        Cameus.KameusThread.capture.release();
                        }
                        catch (Exception e){
                        }
                        System.exit(0);
                        break;
                }
            }
        }
    }
}