/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;

public class DoubleBufferIndexer
extends DoubleIndexer {
    protected DoubleBuffer buffer;

    public DoubleBufferIndexer(DoubleBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public double get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public DoubleIndexer get(int i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public double get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public DoubleIndexer get(int i, int j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public double get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public double get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public DoubleIndexer get(int[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(int i, double d) {
        this.buffer.put(i, d);
        return this;
    }

    @Override
    public DoubleIndexer put(int i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, d[offset + n]);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(int i, int j, double d) {
        this.buffer.put(i * this.strides[0] + j, d);
        return this;
    }

    @Override
    public DoubleIndexer put(int i, int j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, d[offset + n]);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(int i, int j, int k, double d) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, d);
        return this;
    }

    @Override
    public DoubleIndexer put(int[] indices, double d) {
        this.buffer.put(this.index(indices), d);
        return this;
    }

    @Override
    public DoubleIndexer put(int[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, d[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

