/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.indexer.ByteArrayIndexer;
import org.bytedeco.javacpp.indexer.ByteBufferIndexer;
import org.bytedeco.javacpp.indexer.Indexer;

public abstract class ByteIndexer
extends Indexer {
    protected ByteIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static ByteIndexer create(byte[] array, int[] sizes, int[] strides) {
        return new ByteArrayIndexer(array, sizes, strides);
    }

    public static ByteIndexer create(ByteBuffer buffer, int[] sizes, int[] strides) {
        return new ByteBufferIndexer(buffer, sizes, strides);
    }

    public static ByteIndexer create(BytePointer pointer, int[] sizes, int[] strides) {
        return ByteIndexer.create(pointer, sizes, strides, true);
    }

    public static ByteIndexer create(final BytePointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new ByteBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        byte[] array = new byte[pointer.limit() - position];
        pointer.get(array);
        return new ByteArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract byte get(int var1);

    public ByteIndexer get(int i, byte[] b) {
        return this.get(i, b, 0, b.length);
    }

    public abstract ByteIndexer get(int var1, byte[] var2, int var3, int var4);

    public abstract byte get(int var1, int var2);

    public ByteIndexer get(int i, int j, byte[] b) {
        return this.get(i, j, b, 0, b.length);
    }

    public abstract ByteIndexer get(int var1, int var2, byte[] var3, int var4, int var5);

    public abstract byte get(int var1, int var2, int var3);

    public abstract byte get(int ... var1);

    public ByteIndexer get(int[] indices, byte[] b) {
        return this.get(indices, b, 0, b.length);
    }

    public abstract ByteIndexer get(int[] var1, byte[] var2, int var3, int var4);

    public abstract ByteIndexer put(int var1, byte var2);

    public ByteIndexer put(int i, byte ... b) {
        return this.put(i, b, 0, b.length);
    }

    public abstract ByteIndexer put(int var1, byte[] var2, int var3, int var4);

    public abstract ByteIndexer put(int var1, int var2, byte var3);

    public ByteIndexer put(int i, int j, byte ... b) {
        return this.put(i, j, b, 0, b.length);
    }

    public abstract ByteIndexer put(int var1, int var2, byte[] var3, int var4, int var5);

    public abstract ByteIndexer put(int var1, int var2, int var3, byte var4);

    public abstract ByteIndexer put(int[] var1, byte var2);

    public ByteIndexer put(int[] indices, byte ... b) {
        return this.put(indices, b, 0, b.length);
    }

    public abstract ByteIndexer put(int[] var1, byte[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public ByteIndexer putDouble(int[] indices, double b) {
        return this.put(indices, (byte)b);
    }
}

