﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Linq;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using Microsoft.Win32.SafeHandles;

namespace cpg_run
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            //Application.EnableVisualStyles();
            //Application.SetCompatibleTextRenderingDefault(false);
            //Application.Run(new cpgForm());
            List<string> javaPathList = new List<string>();
            try
            {
                //システムのパス一覧を得る
                string paths = Environment.GetEnvironmentVariable("Path", System.EnvironmentVariableTarget.Process);

                // ; で区切ってリストにする
                List<string> pathList = new List<string>(paths.Split(';'));

                //オラクルのjavaのパスに一致する行を得る。
                javaPathList = pathList.Where(a => a.Contains(@"ProgramData\Oracle\Java\javapath") == true).ToList();

            }
            catch
            {
                //上記のメソッドでエラーが起こるようであれば３２ビットと判断する
                string cpg32file = GetCurrentDir() + Path.DirectorySeparatorChar +
                    "CameraPointingGame32" + Path.DirectorySeparatorChar + "CameraPointingGame.exe";

                Process.Start(cpg32file);
                return;
            }

            //一つもなければリターン
            if (javaPathList.Count() == 0)
            {
                DialogResult result2 = MessageBox.Show("jre1.8がインストールされていません", "CameraPointingGame",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information,
                    MessageBoxDefaultButton.Button1);
                return;
            }

            // javaw.exeをパスに加える
            string javaPath = javaPathList[0] + Path.DirectorySeparatorChar + "javaw.exe";

            // javaw.exeのシンボリックシンクのリンク先を得る
            string linkFile = "";
            try
            {
                linkFile = new FileInfo(javaPath).GetSymbolicLinkTarget();

                if ((linkFile == null) || (linkFile.Length == 0))
                {
                    DialogResult result2 = MessageBox.Show("jreのシンボリックリンクを見つけられませんでした", "CameraPointingGame",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Information,
                        MessageBoxDefaultButton.Button1);
                    return;
                }
            }
            catch
            {
                DialogResult result2 = MessageBox.Show("jreのシンボリックリンクを見つけられませんでした", "CameraPointingGame",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information,
                    MessageBoxDefaultButton.Button1);
                return;
            }

            //32bitの場合
            if (IntPtr.Size == 4)
            {
                //32bitOSの場合は(x86)のついたフォルダは無い
                string cpg32file = GetCurrentDir() + Path.DirectorySeparatorChar +
                    "CameraPointingGame32" + Path.DirectorySeparatorChar + "CameraPointingGame.exe";

                Process.Start(cpg32file);
            }
            //64bitの場合
            else if (IntPtr.Size == 8)
            {
                //(x86)のあるなしでx64とx32のjreを使い分ける
                if (linkFile.Contains("(x86)") == true)
                {
                    string cpg32file = GetCurrentDir() + Path.DirectorySeparatorChar +
                        "CameraPointingGame32" + Path.DirectorySeparatorChar + "CameraPointingGame.exe";

                    Process.Start(cpg32file);
                }
                else
                {
                    string cpg32file = GetCurrentDir() + Path.DirectorySeparatorChar +
                        "CameraPointingGame64" + Path.DirectorySeparatorChar + "CameraPointingGame.exe";

                    Process.Start(cpg32file);
                }
            }
            //その他
            else
            {
                string cpg32file = GetCurrentDir() + Path.DirectorySeparatorChar +
                    "CameraPointingGame32" + Path.DirectorySeparatorChar + "CameraPointingGame.exe";

                Process.Start(cpg32file);
            }
        }
        public static string GetCurrentDir()
        {
            // カレントディレクトリを得る
            string dir = System.Reflection.Assembly.GetEntryAssembly().Location;
            string process = Process.GetCurrentProcess().ProcessName.Split('.')[0];
            int num = dir.LastIndexOf(process);//,0);
            string CurrentDir = dir.Remove(num - 1);//, dir.Length);

            return CurrentDir;
        }
    }
}
