/*
 * Decompiled with CFR 0.152.
 */
package MyCanvas.LoadingCanvas;

import MyCanvas.LoadingCanvas.LoadingCanvasBehavior;
import MyMain.CameraPointingGame;
import MyMain.TextData;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class LoadingCanvas {
    private SimpleUniverse simpleU;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 10.0);
    public Canvas3D canvas;
    public PickCanvas cnvs = null;
    public static Transform3D nowLoadingTF3D;
    public static TransformGroup nowLoadingTFG;
    BranchGroup branchG0;
    CameraPointingGame cameraPointingGame;

    public LoadingCanvas(CameraPointingGame cameraPointingGame) {
        this.cameraPointingGame = cameraPointingGame;
        this.canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.canvas.setBounds(0, 0, 1024, 768);
        this.simpleU = new SimpleUniverse(this.canvas);
        this.simpleU.getViewingPlatform().setNominalViewingTransform();
        this.simpleU.addBranchGraph(this.createSceneGraph());
    }

    public void prepareText() {
        nowLoadingTF3D = new Transform3D();
        nowLoadingTF3D.setTranslation(new Vector3f(-0.8f, 0.4f, 0.0f));
        nowLoadingTFG = new TransformGroup(nowLoadingTF3D);
        this.createLoadingText(nowLoadingTFG, "NOW LOADING...");
        this.branchG0.addChild((Node)nowLoadingTFG);
    }

    private void createLoadingText(TransformGroup tg, String str) {
        Text2D text2d = new Text2D(str, new Color3f(0.1f, 0.1f, 0.4f), TextData.FONT, 14, 1);
        Appearance app = text2d.getAppearance();
        app.setCapability(2);
        app.setCapability(3);
        tg.addChild((Node)text2d);
    }

    private BranchGroup createSceneGraph() {
        this.branchG0 = new BranchGroup();
        BufferedImage someImage = null;
        try {
            someImage = ImageIO.read(new File("res/gameback.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ImageComponent2D image = new ImageComponent2D(1, someImage);
        Background background = new Background(image);
        background.setApplicationBounds((Bounds)this.bounds);
        this.branchG0.addChild((Node)background);
        LoadingCanvasBehavior myBehavior3 = new LoadingCanvasBehavior(nowLoadingTFG, this.cameraPointingGame);
        myBehavior3.setSchedulingBounds((Bounds)this.bounds);
        this.branchG0.addChild((Node)myBehavior3);
        this.prepareText();
        this.branchG0.compile();
        return this.branchG0;
    }

    public void destroy() {
        this.simpleU.cleanup();
    }
}

